dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 4, 270, 250, "assets/images/table/cruise", "assets/images/food/item_mark3", "B" );
LManager:AddNewTable( 2, 3, 185, 400, "assets/images/table/cruise", "assets/images/food/item_mark2", "R" );
LManager:AddNewTable( 3, 3, 410, 400, "assets/images/table/cruise", "assets/images/food/item_mark1", "R" );

useFloAsServer = 1;
useWineTable = 1;
numMoodBoosts = 2;
numServers = 1;

maxCoupleHappiness = 200;

-- Group 1
guest = LManager.GenGuest(male01);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = NOT_TABLE + table2;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = male04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = female04;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(1, 6, 3000);


-- Group 2


guest = LManager.GenGuest(female02);
guest.matchType = aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = NOT_TABLE + table1;
guest.percentRequestTissue = 50;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(7, 8, 32000);

-- Group 3


guest = LManager.GenGuest(male01);
guest.matchType = female01;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(9, 9, 55000);


-- Group 4

guest = LManager.GenGuest(female03);
guest.matchType = table3;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(10, 11, 80000);

-- Group 5

guest = LManager.GenGuest(aunt);
guest.matchType = female03;
guest.percentRequestTissue = 30;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = NOT_GUEST + male02;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(12, 13, 100000);


guest = LManager.GenGuest(uncle);
guest.matchType = female04;
guest.percentRequestCoffee = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(14, 16, 130000);

-- Group 6

guest = LManager.GenGuest(female02);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(17, 20, 160000);


LManager:AdjustGuestTolerance(130);


LManager:AddQuinnEvent( "fx/fx_bees.lua", 600, 300, 66000 );


LManager:AddQuinnEvent( "fx/fx_chef_table_fire.lua", 660, 155, 95000 );

LManager:SetLevelSetting ("speakerDelay", 135000); 
LManager:SetLevelSetting ("speakerChance", 30);

-- Set up the Level Settings
LManager:SetLevelNumber(3,8);
LManager:SetLevelScores(8500, 11000);
LManager:SetLevelTime(300000);

LManager:SetLevelSetting ("blaster", 1);

LManager:SetMusic("assets/audio/music/Big Band 1.ogg","assets/audio/music/Dance Dance 1.ogg","assets/audio/music/Uptempo 1.ogg");
LManager:SetBackgroundImage("assets/images/bg_cruise");
LManager:SetChairImage("assets/images/table/chair03");


-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );